par(mfrow = c(1,1))
library(imager)
library(matrixStats)
library(scales)
library(gtools)
library(inflection)
options(scipen = 999)

plotDirectory = 'D:/Manuscripts/Chapter 3 - Fivash et al. 2020 Annals of Botany/Figure 6 - Results of Soil oxygen experiment/Figure components/'

flatPhotoDirectory = 'D:/Manuscripts/Chapter 3 - Fivash et al. 2020 Annals of Botany/Planar optode raw data photos/Flat/Planar optode photos (Flat, for statistics)/'
hollowPhotoDirectory = 'D:/Manuscripts/Chapter 3 - Fivash et al. 2020 Annals of Botany/Planar optode raw data photos/Hollow/Planar optode photos (Hollow)/'
hummockPhotoDirectory = 'D:/Manuscripts/Chapter 3 - Fivash et al. 2020 Annals of Botany/Planar optode raw data photos/Hummock/Planar optode photos (Hummock)/'

for (i_sedimentShape in 1:3){
  
  if(i_sedimentShape == 1){
  tifname = "Figure 7a.tif"
  } else if(i_sedimentShape == 2){
    tifname = "Figure 7b.tif"
  } else if(i_sedimentShape == 3){
    tifname = "Figure 7c.tif"
  }
  
  setwd(plotDirectory)
  tiff(tifname,
       width = 6, height = 6,
       units = 'in', res = 300)
  
  par(mar = c(5,5,4,4))
  plot(c(1), xlim = c(0.0005,100),ylim = c(4,-2), log ='',
       type = 'n',
       xlab = 'Oxygen saturation (%)', ylab = 'Depth (cm)')
  lines(x = c(0,100), y = c(0,0), lty = 2, lwd = 2, col = alpha('black',0.5))
  text('Sediment surface', x = 20, y = -0.5, col = alpha('black',0.5))
  
  if(i_sedimentShape == 1){
    inputDirectory = hollowPhotoDirectory
    sedimentSurfaceDepth.cm = 4.33 # cm
    col = 'yellow'
    photoSeq = seq(230, 265, length.out = 9)
    
    title('Lowered')
    rect(ybottom = 4, ytop = 2, xleft = 100, xright = 0, lty = 0, col = alpha('black',0.1))
    text('Out of frame', x = 50, y = 3)

  } else if(i_sedimentShape == 2){
    inputDirectory = flatPhotoDirectory
    sedimentSurfaceDepth.cm = 3.33 # cm
    title = 'Flat'
    col = 'green'
    photoSeq = c(1163,1166, 1167,1169,1171,1175,1185,1200)
    
    title('Flat')
    rect(ybottom = 4, ytop = 3, xleft = 100, xright = 0, lty = 0, col = alpha('black',0.1))
    text('Out of frame', x = 50, y = 3.5)
    
  } else if(i_sedimentShape == 3){
    inputDirectory = hummockPhotoDirectory
    sedimentSurfaceDepth.cm = 2.33 # cm
    title = 'Raised'
    col = 'blue'
    photoSeq = seq(564,664,10)
    
    title('Raised')
  }
  setwd(inputDirectory)
  
  # make a list for sorted images in the file folder
  filelist = mixedsort(dir())
  
  # time settings
  starttime = as.POSIXct('2018-06-20 17:36:00')
  interval = 120  # 2min=120s between adjacent two images
  
  for(i in photoSeq){
    setwd(inputDirectory)
    filename = filelist[i]
    
    # load images, grayscale, crop, convert class from image to matrix
    p = load.image(filename)
    p.g = grayscale(p)
    p.g.c = as.cimg(p.g[205:660,120:710, 1, 1])
    m = as.matrix(p.g.c)
    m = m*100

    # synchronize depth layers in cm and in pixel
    depth = seq(0,6.24, length.out = dim(m)[2]) - sedimentSurfaceDepth.cm # depth in "cm"
    
    # calculate the mean values and SE in columns
    se = colSds(m)/sqrt(dim(m)[1])
    oxygen.mean = colMeans(m)
    x = oxygen.mean
    interval = 5
    xMean = c()
    for(i_window in 1:length(x)){
      start = i_window
      end = start + interval
      
      xMean[i_window] = mean(x[start:end], na.rm = T)
    }
    
    filter = depth > -2
    points(depth[filter] ~ oxygen.mean[filter], pch = '.')

    inflectionPoint = bese(depth, xMean, index = 1)$iplast
    
    filter = which.min(abs(xMean - 50))
    points(depth[filter] ~ xMean[filter], cex = 2, pch = 21, bg = alpha(col,0.5))
    
    filter = (depth > inflectionPoint)
    y = oxygen.mean[filter]
    x = depth[filter] - min(depth[filter])

    c = 1.4
    m = nls(y ~ exp(a + b*x) + c, start = list(a = 3.8, b = -3.5))
    summary(m)
    a = summary(m)$coefficients[1]
    b = summary(m)$coefficients[2]
    xv = seq(0,3, length.out = 1000)
    yv = exp(a + b*xv) + c

    xv2 = xv + min(depth[filter])
    lineFilter = xv2 < max(depth) & yv < 50
    lines(xv2[lineFilter] ~ yv[lineFilter], col = alpha(col,0.5), lwd = 2)
    
    print(paste(i,'/',length(filelist),';',b, sep = ' '))
    # oxygenDeclineRate[i] = b
  }
  
  if(i_sedimentShape == 1){
    text(y = 1.3, x = 20, 'time')
    arrows(x0 = 15, x1 = 15, y0 = 1.5, y1 =  0.3, length = 0.1, lwd = 2)
    text(y = 0.5, x = 55, expression(t[1]))
    text(y = 0.2, x = 54, expression(t[2]))
  } else if(i_sedimentShape == 2){
    text(y = 2.4, x = 25, 'time')
    arrows(x0 = 20, x1 = 20, y0 = 2.8, y1 =  0.6, length = 0.1, lwd = 2)
    text(y = 2.8, x = 54, expression(t[1]))
    text(y = 1.4, x = 53, expression(t[2]))
    text(y = 1, x = 54, expression(t[3]))
  } else if(i_sedimentShape == 3){
    text(y = 3.7, x = 28, 'time')
    arrows(x0 = 23, x1 = 23, y0 = 3.8, y1 =  0.6, length = 0.1, lwd = 2)
    text(y = 3.9, x = 53, expression(t[1]))
    text(y = 3.2, x = 53.5, expression(t[2]))
    text(y = 2.65, x = 54, expression(t[3]))
  }
  
  setwd(plotDirectory)
  dev.off()
}